# -*- coding: utf-8 -*-
"""
Created on Tue May 17 19:32:43 2016

@author: ci1vcs
"""
import numpy as np
import math
import matplotlib.pyplot as plt

def OffsetArrays(AThreeDArray,AOffset): 
    
    x_length = len(AThreeDArray[:,0,0]) 
    t_length = len(AThreeDArray[0,:,0])
    m_length = len(AThreeDArray[0,0,:])
    
    ATwoDArray = np.zeros((x_length,t_length+AOffset),float)
    
    for m in range(0,m_length-1):
        for t in range(1,t_length):
            ATwoDArray[:,0] = AThreeDArray[:,0,0]
            ATwoDArray[:,t] = AThreeDArray[:,t,m]+AThreeDArray[:,t-1,m+1]
            ATwoDArray[:,-1]= AThreeDArray[:,t,m_length-1]
    return ATwoDArray
        


# Inputs
#X = np.linspace(1,500,5)

X = [2500, 2797, 3093, 3818]
T = np.linspace(0,32400,81)
#T = np.linspace(1,9,100)
#T = T = T*3600
M = [15116.7,0]

x_length = len(X)
t_length = len(T)
m_length =len(M)

Dx = 4.01
velocity_river = 0.225
area_river= 10.63

# model
C = np.zeros((x_length, t_length,m_length), float)

for time_index in np.arange(1,t_length):
    t = T[time_index]
    for x_index in np.arange(0,x_length):
        x = X[x_index]
        for m_index in np.arange(0,m_length):
            m = M[m_index]
            C[x_index,time_index,m_index]=  m/(area_river * math.sqrt(4*math.pi*Dx*t)) * math.exp(-(x - (velocity_river*t))**2./(4.*Dx*t))    


C2 = OffsetArrays(C,1)
T_new = np.linspace(0,32805,82)/3600
plt.plot(T_new,C2[0,:])
plt.show()
plt.plot(T_new,C2[1,:])
plt.show()
plt.plot(T_new,C2[2,:])
plt.show()
plt.plot(T_new,C2[3,:])
plt.show()

    
    
    
    
    
    
    
    
    
    
    
    
    
    
    